/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.NativeLong;
import com.kenai.jaffl.ParameterFlags;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.annotations.StdCall;
import com.kenai.jaffl.byref.ByReference;
import com.kenai.jaffl.mapper.FromNativeContext;
import com.kenai.jaffl.mapper.FromNativeConverter;
import com.kenai.jaffl.mapper.FunctionMapper;
import com.kenai.jaffl.mapper.MethodResultContext;
import com.kenai.jaffl.mapper.ToNativeContext;
import com.kenai.jaffl.mapper.ToNativeConverter;
import com.kenai.jaffl.mapper.TypeMapper;
import com.kenai.jaffl.provider.InvocationSession;
import com.kenai.jaffl.provider.Invoker;
import com.kenai.jaffl.provider.Library;
import com.kenai.jaffl.provider.StringIO;
import com.kenai.jaffl.provider.jffi.AsmRuntime;
import com.kenai.jaffl.provider.jffi.DirectMemoryIO;
import com.kenai.jaffl.provider.jffi.IdentityFunctionMapper;
import com.kenai.jaffl.provider.jffi.InvokerFactory;
import com.kenai.jaffl.provider.jffi.InvokerUtil;
import com.kenai.jaffl.provider.jffi.MemoryUtil;
import com.kenai.jaffl.provider.jffi.NullTypeMapper;
import com.kenai.jaffl.struct.Struct;
import com.kenai.jaffl.util.EnumMapper;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultInvokerFactory
implements InvokerFactory {
    DefaultInvokerFactory() {
    }

    public static final InvokerFactory getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public final boolean isMethodSupported(Method method) {
        return true;
    }

    @Override
    public final Invoker createInvoker(Method method, Library library, Map<LibraryOption, ?> map) {
        FunctionMapper functionMapper = map.containsKey((Object)LibraryOption.FunctionMapper) ? (FunctionMapper)map.get((Object)LibraryOption.FunctionMapper) : IdentityFunctionMapper.INSTANCE;
        long l = ((com.kenai.jaffl.provider.jffi.Library)library).findSymbolAddress(functionMapper.mapFunctionName(method.getName(), null));
        TypeMapper typeMapper = map.containsKey((Object)LibraryOption.TypeMapper) ? (TypeMapper)map.get((Object)LibraryOption.TypeMapper) : NullTypeMapper.INSTANCE;
        CallingConvention callingConvention = method.getAnnotation(StdCall.class) != null ? CallingConvention.STDCALL : InvokerUtil.getCallingConvention(map);
        Marshaller[] marshallerArray = new Marshaller[method.getParameterTypes().length];
        Type[] typeArray = new Type[marshallerArray.length];
        for (int i = 0; i < marshallerArray.length; ++i) {
            marshallerArray[i] = DefaultInvokerFactory.getMarshaller(method, i, typeMapper);
            typeArray[i] = DefaultInvokerFactory.getNativeParameterType(method, i, typeMapper);
        }
        Class<Object> clazz = method.getReturnType();
        FromNativeConverter fromNativeConverter = typeMapper.getFromNativeConverter(clazz);
        if (fromNativeConverter != null) {
            clazz = fromNativeConverter.nativeType();
        }
        Function function = new Function(l, DefaultInvokerFactory.getNativeReturnType(clazz), typeArray, callingConvention, InvokerUtil.requiresErrno(method));
        FunctionInvoker functionInvoker = DefaultInvokerFactory.getFunctionInvoker(clazz);
        if (fromNativeConverter != null) {
            MethodResultContext methodResultContext = new MethodResultContext(method);
            functionInvoker = new ConvertingInvoker(fromNativeConverter, methodResultContext, functionInvoker);
        }
        return DefaultInvokerFactory.isSessionRequired(marshallerArray) ? new SessionInvoker(function, functionInvoker, marshallerArray) : new DefaultInvoker(function, functionInvoker, marshallerArray);
    }

    private static final boolean isSessionRequired(Marshaller[] marshallerArray) {
        for (Marshaller marshaller : marshallerArray) {
            if (!marshaller.isSessionRequired()) continue;
            return true;
        }
        return false;
    }

    private static final FunctionInvoker getFunctionInvoker(Class clazz) {
        if (Void.class.isAssignableFrom(clazz) || Void.TYPE == clazz) {
            return VoidInvoker.INSTANCE;
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE == clazz) {
            return BooleanInvoker.INSTANCE;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return new EnumInvoker(clazz);
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE == clazz) {
            return Int8Invoker.INSTANCE;
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE == clazz) {
            return Int16Invoker.INSTANCE;
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE == clazz) {
            return Int32Invoker.INSTANCE;
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE == clazz) {
            return Int64Invoker.INSTANCE;
        }
        if (NativeLong.class.isAssignableFrom(clazz)) {
            return Platform.getPlatform().longSize() == 32 ? NativeLong32Invoker.INSTANCE : NativeLong64Invoker.INSTANCE;
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE == clazz) {
            return Float32Invoker.INSTANCE;
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE == clazz) {
            return Float64Invoker.INSTANCE;
        }
        if (Pointer.class.isAssignableFrom(clazz)) {
            return PointerInvoker.INSTANCE;
        }
        if (Struct.class.isAssignableFrom(clazz)) {
            return new StructInvoker(clazz);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return StringInvoker.INSTANCE;
        }
        throw new IllegalArgumentException("Unknown return type: " + clazz);
    }

    private static final Type getNativeReturnType(Class clazz) {
        if (Void.class.isAssignableFrom(clazz) || Void.TYPE == clazz) {
            return Type.VOID;
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE == clazz) {
            return Type.SINT32;
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE == clazz) {
            return Type.SINT8;
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE == clazz) {
            return Type.SINT16;
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE == clazz) {
            return Type.SINT32;
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE == clazz) {
            return Type.SINT64;
        }
        if (NativeLong.class.isAssignableFrom(clazz)) {
            return Platform.getPlatform().longSize() == 32 ? Type.SINT32 : Type.SINT64;
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE == clazz) {
            return Type.FLOAT;
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE == clazz) {
            return Type.DOUBLE;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return Type.SINT32;
        }
        if (Pointer.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (Struct.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        throw new IllegalArgumentException("Unsupported return type: " + clazz);
    }

    private static final Type getNativeParameterType(Method method, int n, TypeMapper typeMapper) {
        Class<?> clazz = method.getParameterTypes()[n];
        ToNativeConverter toNativeConverter = typeMapper.getToNativeConverter(clazz);
        return DefaultInvokerFactory.getNativeParameterType(toNativeConverter != null ? toNativeConverter.nativeType() : clazz);
    }

    private static final Type getNativeParameterType(Class clazz) {
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE == clazz) {
            return Type.SINT8;
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE == clazz) {
            return Type.SINT16;
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE == clazz) {
            return Type.SINT32;
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE == clazz) {
            return Type.SINT64;
        }
        if (NativeLong.class.isAssignableFrom(clazz)) {
            return Platform.getPlatform().longSize() == 32 ? Type.SINT32 : Type.SINT64;
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE == clazz) {
            return Type.FLOAT;
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE == clazz) {
            return Type.DOUBLE;
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE == clazz) {
            return Type.SINT32;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return Type.SINT32;
        }
        if (Pointer.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (Struct.class.isAssignableFrom(clazz) || clazz.isArray() && Struct.class.isAssignableFrom(clazz.getComponentType())) {
            return Type.POINTER;
        }
        if (Buffer.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (ByReference.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (clazz.isArray()) {
            return Type.POINTER;
        }
        throw new IllegalArgumentException("Unsupported parameter type: " + clazz);
    }

    static final int getParameterFlags(Method method, int n) {
        return DefaultInvokerFactory.getParameterFlags(method.getParameterAnnotations()[n]);
    }

    static final int getParameterFlags(Annotation[] annotationArray) {
        return ParameterFlags.parse(annotationArray);
    }

    static final int getNativeArrayFlags(int n) {
        int n2 = 0;
        n2 |= ParameterFlags.isIn(n) ? 1 : 0;
        n2 |= ParameterFlags.isOut(n) ? 2 : 0;
        return n2 |= ParameterFlags.isNulTerminate(n) ? 4 : 0;
    }

    static final int getNativeArrayFlags(Annotation[] annotationArray) {
        return DefaultInvokerFactory.getNativeArrayFlags(DefaultInvokerFactory.getParameterFlags(annotationArray));
    }

    static final Marshaller getMarshaller(Method method, int n, TypeMapper typeMapper) {
        ToNativeConverter toNativeConverter;
        Class<?> clazz = method.getParameterTypes()[n];
        ToNativeConverter toNativeConverter2 = toNativeConverter = typeMapper != null ? typeMapper.getToNativeConverter(clazz) : null;
        if (toNativeConverter != null) {
            return new ToNativeConverterMarshaller(toNativeConverter, DefaultInvokerFactory.getMarshaller(toNativeConverter.nativeType(), method.getParameterAnnotations()[n]));
        }
        return DefaultInvokerFactory.getMarshaller(method, n);
    }

    static final Marshaller getMarshaller(Method method, int n) {
        return DefaultInvokerFactory.getMarshaller(method.getParameterTypes()[n], method.getParameterAnnotations()[n]);
    }

    static final Marshaller getMarshaller(Class clazz, Annotation[] annotationArray) {
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE == clazz) {
            return Int8Marshaller.INSTANCE;
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE == clazz) {
            return Int16Marshaller.INSTANCE;
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE == clazz) {
            return Int32Marshaller.INSTANCE;
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE == clazz) {
            return Int64Marshaller.INSTANCE;
        }
        if (NativeLong.class.isAssignableFrom(clazz)) {
            return Platform.getPlatform().longSize() == 32 ? Int32Marshaller.INSTANCE : Int64Marshaller.INSTANCE;
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE == clazz) {
            return Float32Marshaller.INSTANCE;
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE == clazz) {
            return Float64Marshaller.INSTANCE;
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE == clazz) {
            return BooleanMarshaller.INSTANCE;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return EnumMarshaller.INSTANCE;
        }
        if (Pointer.class.isAssignableFrom(clazz)) {
            return PointerMarshaller.INSTANCE;
        }
        if (StringBuffer.class.isAssignableFrom(clazz)) {
            return new StringBufferMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (StringBuilder.class.isAssignableFrom(clazz)) {
            return new StringBuilderMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return CharSequenceMarshaller.INSTANCE;
        }
        if (ByReference.class.isAssignableFrom(clazz)) {
            return new ByReferenceMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (Struct.class.isAssignableFrom(clazz)) {
            return new StructMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (ByteBuffer.class.isAssignableFrom(clazz)) {
            return new ByteBufferMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (ShortBuffer.class.isAssignableFrom(clazz)) {
            return new ShortBufferMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (IntBuffer.class.isAssignableFrom(clazz)) {
            return new IntBufferMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (LongBuffer.class.isAssignableFrom(clazz)) {
            return new LongBufferMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (FloatBuffer.class.isAssignableFrom(clazz)) {
            return new FloatBufferMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (DoubleBuffer.class.isAssignableFrom(clazz)) {
            return new DoubleBufferMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (clazz.isArray() && clazz.getComponentType() == Byte.TYPE) {
            return new ByteArrayMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (clazz.isArray() && clazz.getComponentType() == Short.TYPE) {
            return new ShortArrayMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (clazz.isArray() && clazz.getComponentType() == Integer.TYPE) {
            return new IntArrayMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (clazz.isArray() && clazz.getComponentType() == Long.TYPE) {
            return new LongArrayMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (clazz.isArray() && clazz.getComponentType() == Float.TYPE) {
            return new FloatArrayMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (clazz.isArray() && clazz.getComponentType() == Double.TYPE) {
            return new DoubleArrayMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        if (clazz.isArray() && Struct.class.isAssignableFrom(clazz.getComponentType())) {
            return new StructArrayMarshaller(DefaultInvokerFactory.getParameterFlags(annotationArray));
        }
        throw new IllegalArgumentException("Unsupported parameter type: " + clazz);
    }

    static abstract class BaseInvoker
    implements FunctionInvoker {
        static final com.kenai.jffi.Invoker invoker = com.kenai.jffi.Invoker.getInstance();

        BaseInvoker() {
        }
    }

    static abstract class BaseMarshaller
    implements Marshaller {
        BaseMarshaller() {
        }

        public boolean isSessionRequired() {
            return false;
        }

        public void marshal(InvocationSession invocationSession, InvocationBuffer invocationBuffer, Object object) {
            this.marshal(invocationBuffer, object);
        }
    }

    static final class BooleanInvoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new BooleanInvoker();

        BooleanInvoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            return invoker.invokeInt(function, heapInvocationBuffer) != 0;
        }
    }

    static final class BooleanMarshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new BooleanMarshaller();

        BooleanMarshaller() {
        }

        public void marshal(InvocationBuffer invocationBuffer, Object object) {
            invocationBuffer.putInt((Boolean)object != false ? 1 : 0);
        }
    }

    static final class ByReferenceMarshaller
    extends SessionRequiredMarshaller {
        private final int flags;

        public ByReferenceMarshaller(int n) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(n);
        }

        public final void marshal(InvocationSession invocationSession, InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationSession, invocationBuffer, (ByReference)object, this.flags);
        }
    }

    static final class ByteArrayMarshaller
    extends BaseMarshaller {
        private final int flags;

        public ByteArrayMarshaller(int n) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(n | (ParameterFlags.isIn(n) ? 8 : 0));
        }

        public final void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (byte[])byte[].class.cast(object), this.flags);
        }
    }

    static final class ByteBufferMarshaller
    extends BaseMarshaller {
        private final int flags;

        public ByteBufferMarshaller(int n) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(n | (ParameterFlags.isIn(n) ? 8 : 0));
        }

        public final void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (ByteBuffer)object, this.flags);
        }
    }

    static final class CharSequenceMarshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new CharSequenceMarshaller();

        CharSequenceMarshaller() {
        }

        public void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (CharSequence)object);
        }
    }

    static final class ConvertingInvoker
    extends BaseInvoker {
        private final FromNativeConverter converter;
        private final FromNativeContext context;
        private final FunctionInvoker nativeInvoker;

        public ConvertingInvoker(FromNativeConverter fromNativeConverter, FromNativeContext fromNativeContext, FunctionInvoker functionInvoker) {
            this.converter = fromNativeConverter;
            this.context = fromNativeContext;
            this.nativeInvoker = functionInvoker;
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            return this.converter.fromNative(this.nativeInvoker.invoke(function, heapInvocationBuffer), this.context);
        }
    }

    static final class DefaultInvoker
    implements Invoker {
        final Function function;
        final FunctionInvoker functionInvoker;
        final Marshaller[] marshallers;

        DefaultInvoker(Function function, FunctionInvoker functionInvoker, Marshaller[] marshallerArray) {
            this.function = function;
            this.functionInvoker = functionInvoker;
            this.marshallers = marshallerArray;
        }

        final HeapInvocationBuffer marshal(Object[] objectArray) {
            HeapInvocationBuffer heapInvocationBuffer = new HeapInvocationBuffer(this.function);
            for (int i = 0; i < objectArray.length; ++i) {
                this.marshallers[i].marshal(heapInvocationBuffer, objectArray[i]);
            }
            return heapInvocationBuffer;
        }

        public final Object invoke(Object[] objectArray) {
            return this.functionInvoker.invoke(this.function, this.marshal(objectArray));
        }
    }

    static final class DoubleArrayMarshaller
    extends BaseMarshaller {
        private final int flags;

        public DoubleArrayMarshaller(int n) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(n);
        }

        public final void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (double[])double[].class.cast(object), this.flags);
        }
    }

    static final class DoubleBufferMarshaller
    extends BaseMarshaller {
        private final int flags;

        public DoubleBufferMarshaller(int n) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(n);
        }

        public final void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (DoubleBuffer)object, this.flags);
        }
    }

    static final class EnumInvoker
    extends BaseInvoker {
        private final Class enumClass;

        private EnumInvoker(Class clazz) {
            this.enumClass = clazz;
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            return EnumMapper.getInstance().valueOf(invoker.invokeInt(function, heapInvocationBuffer), this.enumClass);
        }
    }

    static final class EnumMarshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new EnumMarshaller();

        EnumMarshaller() {
        }

        public void marshal(InvocationBuffer invocationBuffer, Object object) {
            invocationBuffer.putInt(EnumMapper.getInstance().intValue((Enum)object));
        }
    }

    static final class Float32Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new Float32Invoker();

        Float32Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            return Float.valueOf(invoker.invokeFloat(function, heapInvocationBuffer));
        }
    }

    static final class Float32Marshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new Float32Marshaller();

        Float32Marshaller() {
        }

        public void marshal(InvocationBuffer invocationBuffer, Object object) {
            invocationBuffer.putFloat(((Number)object).floatValue());
        }
    }

    static final class Float64Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new Float64Invoker();

        Float64Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            return invoker.invokeDouble(function, heapInvocationBuffer);
        }
    }

    static final class Float64Marshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new Float64Marshaller();

        Float64Marshaller() {
        }

        public void marshal(InvocationBuffer invocationBuffer, Object object) {
            invocationBuffer.putDouble(((Number)object).doubleValue());
        }
    }

    static final class FloatArrayMarshaller
    extends BaseMarshaller {
        private final int flags;

        public FloatArrayMarshaller(int n) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(n);
        }

        public final void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (float[])float[].class.cast(object), this.flags);
        }
    }

    static final class FloatBufferMarshaller
    extends BaseMarshaller {
        private final int flags;

        public FloatBufferMarshaller(int n) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(n);
        }

        public final void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (FloatBuffer)object, this.flags);
        }
    }

    static interface FunctionInvoker {
        public Object invoke(Function var1, HeapInvocationBuffer var2);
    }

    static final class Int16Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new Int16Invoker();

        Int16Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            return (short)invoker.invokeInt(function, heapInvocationBuffer);
        }
    }

    static final class Int16Marshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new Int16Marshaller();

        Int16Marshaller() {
        }

        public void marshal(InvocationBuffer invocationBuffer, Object object) {
            invocationBuffer.putShort(((Number)object).intValue());
        }
    }

    static final class Int32Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new Int32Invoker();

        Int32Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            return invoker.invokeInt(function, heapInvocationBuffer);
        }
    }

    static final class Int32Marshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new Int32Marshaller();

        Int32Marshaller() {
        }

        public void marshal(InvocationBuffer invocationBuffer, Object object) {
            invocationBuffer.putInt(((Number)object).intValue());
        }
    }

    static final class Int64Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new Int64Invoker();

        Int64Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            return invoker.invokeLong(function, heapInvocationBuffer);
        }
    }

    static final class Int64Marshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new Int64Marshaller();

        Int64Marshaller() {
        }

        public void marshal(InvocationBuffer invocationBuffer, Object object) {
            invocationBuffer.putLong(((Number)object).longValue());
        }
    }

    static final class Int8Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new Int8Invoker();

        Int8Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            return (byte)invoker.invokeInt(function, heapInvocationBuffer);
        }
    }

    static final class Int8Marshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new Int8Marshaller();

        Int8Marshaller() {
        }

        public void marshal(InvocationBuffer invocationBuffer, Object object) {
            invocationBuffer.putByte(((Number)object).intValue());
        }
    }

    static final class IntArrayMarshaller
    extends BaseMarshaller {
        private final int flags;

        public IntArrayMarshaller(int n) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(n);
        }

        public final void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (int[])int[].class.cast(object), this.flags);
        }
    }

    static final class IntBufferMarshaller
    extends BaseMarshaller {
        private final int flags;

        public IntBufferMarshaller(int n) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(n);
        }

        public final void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (IntBuffer)object, this.flags);
        }
    }

    static final class LongArrayMarshaller
    extends BaseMarshaller {
        private final int flags;

        public LongArrayMarshaller(int n) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(n);
        }

        public final void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (long[])long[].class.cast(object), this.flags);
        }
    }

    static final class LongBufferMarshaller
    extends BaseMarshaller {
        private final int flags;

        public LongBufferMarshaller(int n) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(n);
        }

        public final void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (LongBuffer)object, this.flags);
        }
    }

    static interface Marshaller {
        public boolean isSessionRequired();

        public void marshal(InvocationSession var1, InvocationBuffer var2, Object var3);

        public void marshal(InvocationBuffer var1, Object var2);
    }

    static final class NativeLong32Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new NativeLong32Invoker();

        NativeLong32Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            return NativeLong.valueOf(invoker.invokeInt(function, heapInvocationBuffer));
        }
    }

    static final class NativeLong64Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new NativeLong64Invoker();

        NativeLong64Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            return NativeLong.valueOf(invoker.invokeLong(function, heapInvocationBuffer));
        }
    }

    static final class PointerInvoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new PointerInvoker();

        PointerInvoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            return MemoryUtil.newPointer(invoker.invokeAddress(function, heapInvocationBuffer));
        }
    }

    static final class PointerMarshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new PointerMarshaller();

        PointerMarshaller() {
        }

        public void marshal(InvocationBuffer invocationBuffer, Object object) {
            invocationBuffer.putAddress(((Pointer)object).address());
        }
    }

    static final class SessionInvoker
    implements Invoker {
        static final com.kenai.jffi.Invoker invoker = com.kenai.jffi.Invoker.getInstance();
        final Function function;
        final FunctionInvoker functionInvoker;
        final Marshaller[] marshallers;

        SessionInvoker(Function function, FunctionInvoker functionInvoker, Marshaller[] marshallerArray) {
            this.function = function;
            this.functionInvoker = functionInvoker;
            this.marshallers = marshallerArray;
        }

        final HeapInvocationBuffer marshal(InvocationSession invocationSession, Object[] objectArray) {
            HeapInvocationBuffer heapInvocationBuffer = new HeapInvocationBuffer(this.function);
            for (int i = 0; i < objectArray.length; ++i) {
                this.marshallers[i].marshal(invocationSession, heapInvocationBuffer, objectArray[i]);
            }
            return heapInvocationBuffer;
        }

        public final Object invoke(Object[] objectArray) {
            InvocationSession invocationSession = new InvocationSession();
            Object object = this.functionInvoker.invoke(this.function, this.marshal(invocationSession, objectArray));
            invocationSession.finish();
            return object;
        }
    }

    static abstract class SessionRequiredMarshaller
    extends BaseMarshaller {
        SessionRequiredMarshaller() {
        }

        public final boolean isSessionRequired() {
            return true;
        }

        public void marshal(InvocationBuffer invocationBuffer, Object object) {
            throw new UnsupportedOperationException("Cannot marshal this type without session");
        }
    }

    static final class ShortArrayMarshaller
    extends BaseMarshaller {
        private final int flags;

        public ShortArrayMarshaller(int n) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(n);
        }

        public final void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (short[])short[].class.cast(object), this.flags);
        }
    }

    static final class ShortBufferMarshaller
    extends BaseMarshaller {
        private final int flags;

        public ShortBufferMarshaller(int n) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(n);
        }

        public final void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (ShortBuffer)object, this.flags);
        }
    }

    private static final class SingletonHolder {
        static InvokerFactory INSTANCE = new DefaultInvokerFactory();

        private SingletonHolder() {
        }
    }

    static final class StringBufferMarshaller
    extends SessionRequiredMarshaller {
        private final int nflags;
        private final int inout;

        public StringBufferMarshaller(int n) {
            this.inout = n;
            this.nflags = DefaultInvokerFactory.getNativeArrayFlags(n | (ParameterFlags.isIn(n) ? 8 : 0));
        }

        public void marshal(InvocationSession invocationSession, InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationSession, invocationBuffer, (StringBuffer)object, this.inout, this.nflags);
        }
    }

    static final class StringBuilderMarshaller
    extends SessionRequiredMarshaller {
        private final int nflags;
        private final int inout;

        public StringBuilderMarshaller(int n) {
            this.inout = n;
            this.nflags = DefaultInvokerFactory.getNativeArrayFlags(n | (ParameterFlags.isIn(n) ? 8 : 0));
        }

        public void marshal(InvocationSession invocationSession, InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationSession, invocationBuffer, (StringBuilder)object, this.inout, this.nflags);
        }
    }

    static final class StringInvoker
    extends BaseInvoker {
        MemoryIO IO = MemoryIO.getInstance();
        static final FunctionInvoker INSTANCE = new StringInvoker();

        StringInvoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            long l = invoker.invokeAddress(function, heapInvocationBuffer);
            if (l == 0L) {
                return null;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.IO.getZeroTerminatedByteArray(l));
            return ((Object)StringIO.getStringIO().fromNative(byteBuffer)).toString();
        }
    }

    static final class StructArrayMarshaller
    extends BaseMarshaller {
        private final int nflags;
        private final int flags;

        public StructArrayMarshaller(int n) {
            this.flags = n;
            this.nflags = DefaultInvokerFactory.getNativeArrayFlags(n);
        }

        public final void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (Struct[])Struct[].class.cast(object), this.flags, this.nflags);
        }
    }

    static final class StructInvoker
    extends BaseInvoker {
        private final Class structClass;

        public StructInvoker(Class clazz) {
            this.structClass = clazz;
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            long l = invoker.invokeAddress(function, heapInvocationBuffer);
            if (l == 0L) {
                return null;
            }
            try {
                Struct struct2 = (Struct)this.structClass.newInstance();
                struct2.useMemory(new DirectMemoryIO(l));
                return struct2;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    static final class StructMarshaller
    extends BaseMarshaller {
        private final int nflags;
        private final int flags;

        public StructMarshaller(int n) {
            this.flags = n;
            this.nflags = DefaultInvokerFactory.getNativeArrayFlags(n);
        }

        public final void marshal(InvocationBuffer invocationBuffer, Object object) {
            AsmRuntime.marshal(invocationBuffer, (Struct)object, this.flags, this.nflags);
        }
    }

    static final class ToNativeConverterMarshaller
    extends BaseMarshaller {
        private final ToNativeConverter converter;
        private final ToNativeContext context = null;
        private final Marshaller marshaller;

        public ToNativeConverterMarshaller(ToNativeConverter toNativeConverter, Marshaller marshaller) {
            this.converter = toNativeConverter;
            this.marshaller = marshaller;
        }

        public void marshal(InvocationBuffer invocationBuffer, Object object) {
            this.marshaller.marshal(invocationBuffer, this.converter.toNative(object, this.context));
        }

        public boolean isSessionRequired() {
            return this.marshaller.isSessionRequired();
        }

        public void marshal(InvocationSession invocationSession, InvocationBuffer invocationBuffer, Object object) {
            this.marshaller.marshal(invocationSession, invocationBuffer, this.converter.toNative(object, this.context));
        }
    }

    static final class VoidInvoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new VoidInvoker();

        VoidInvoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            invoker.invokeInt(function, heapInvocationBuffer);
            return null;
        }
    }
}

